/* Copyright (C) 1997 Agilent Technologies */
/* VXIplug&play Instrument Driver for the Agilent E1445*/

#ifndef hpe1445_INCLUDE 
#define hpe1445_INCLUDE
#include "vpptype.h"

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif
/******************************************************
 * INSTR_DEVELOPER: Take out what you don't need 
 ******************************************************
 */

/******  Returned error status values *****/
/* Common Error numbers start at BFFC0D00 */
#define hpe1445_INSTR_ERROR_NOT_VXI       (_VI_ERROR+0x3FFC0D00L) /* 0xBFFC0D00 */
/* D01 unused*/
#define hpe1445_INSTR_ERROR_NULL_PTR      (_VI_ERROR+0x3FFC0D02L) /* 0xBFFC0D02 */
#define hpe1445_INSTR_ERROR_RESET_FAILED  (_VI_ERROR+0x3FFC0D03L) /* 0xBFFC0D03 */
#define hpe1445_INSTR_ERROR_UNEXPECTED    (_VI_ERROR+0x3FFC0D04L) /* 0xBFFC0D04 */
#define hpe1445_INSTR_ERROR_INV_SESSION   (_VI_ERROR+0x3FFC0D05L) /* 0xBFFC0D05 */
#define hpe1445_INSTR_ERROR_LOOKUP        (_VI_ERROR+0x3FFC0D06L) /* 0xBFFC0D06 */
#define hpe1445_INSTR_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L) /* 0xBFFC0D07 */
#define hpe1445_ERR_NOTFOUND      	       (_VI_ERROR+0x3FFC0D08L) /* 0xBFFC0D08 */
#define hpe1445_ERR_NOBEGIN			   (_VI_ERROR+0x3FFC0D0AL) /* 0xBFFC0D0A */
#define	hpe1445_ERR_SEGNAME			   (_VI_ERROR+0x3FFC0D0BL) /* 0xBFFC0D0B */
/* Parameter errors not in VPP 3.4 */
#define hpe1445_INSTR_ERROR_PARAMETER9	(_VI_ERROR+0x3FFC0D20L)/* 0xBFFC0D20 */
#define hpe1445_INSTR_ERROR_PARAMETER10	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D21 */
#define hpe1445_INSTR_ERROR_PARAMETER11	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D22 */
#define hpe1445_INSTR_ERROR_PARAMETER12	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D23 */
#define hpe1445_INSTR_ERROR_PARAMETER13	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D24 */
#define hpe1445_INSTR_ERROR_PARAMETER14	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D25 */
#define hpe1445_INSTR_ERROR_PARAMETER15	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D26 */
#define hpe1445_INSTR_ERROR_PARAMETER16	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D27 */
#define hpe1445_INSTR_ERROR_PARAMETER17	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D28 */
#define hpe1445_INSTR_ERROR_PARAMETER18	(_VI_ERROR+0x3FFC0D21L)/* 0xBFFC0D29 */

/******   Used by Status System Functions   *****/
/* these defines are bit numbers and need to be defined by
   each driver
*/

#define hpe1445_QUES_VOLT				1
#define hpe1445_QUES_CURR				2
#define hpe1445_QUES_TIME				4
#define hpe1445_QUES_POW				8
#define hpe1445_QUES_TEMP				16
#define hpe1445_QUES_FREQ				32
#define hpe1445_QUES_PHAS				64
#define hpe1445_QUES_MOD				128
#define hpe1445_QUES_CAL				256
#define hpe1445_QUES_AVAIL10			512
#define hpe1445_QUES_AVAIL11			1024
#define hpe1445_QUES_AVAIL12			2048
#define hpe1445_QUES_AVAIL13			4096
#define hpe1445_QUES_INST				8192
#define hpe1445_QUES_CMD_WARN			16384

#define hpe1445_OPER_CAL				1
#define hpe1445_OPER_SETT				2
#define hpe1445_OPER_RANG				4
#define hpe1445_OPER_SWE				8
#define hpe1445_OPER_MEAS				16
#define hpe1445_OPER_TRIG				32
#define hpe1445_OPER_ARM				64
#define hpe1445_OPER_CORR				128
#define hpe1445_OPER_AVAIL9			256
#define hpe1445_OPER_AVAIL10			512
#define hpe1445_OPER_AVAIL11			1024
#define hpe1445_OPER_AVAIL12			2048
#define hpe1445_OPER_AVAIL13			4096
#define hpe1445_OPER_INST				8192
#define hpe1445_OPER_PROG				16384

/******   Used by Function hpe1445_timeOut   *****/

/******   Used by Function hpe1445_timeOut   *****/
#define  hpe1445_TIMEOUT_MAX  2147483647
#define  hpe1445_TIMEOUT_MIN  0

/* used by cmdString_Q */
#define hpe1445_CMDSTRING_Q_MIN	2
#define hpe1445_CMDSTRINGFP_Q_MAX	2147483647L

/* used by cmdData_Q FUNC */
#define hpe1445_CMDDATA_Q_MIN	2
#define hpe1445_CMDDATA_Q_MAX	2147483647L

#define hpe1445_CMDINT32ARR_Q_MIN	1L
#define hpe1445_CMDINT32ARR_Q_MAX	2147483647L

#define hpe1445_CMDINT16ARR_Q_MIN	1L
#define hpe1445_CMDINT16ARR_Q_MAX	2147483647L

#define hpe1445_CMDREAL32ARR_Q_MIN	1L
#define hpe1445_CMDREAL32ARR_Q_MAX	2147483647L

#define hpe1445_CMDREAL64ARR_Q_MIN	1L
#define hpe1445_CMDREAL64ARR_Q_MAX	2147483647L

/* required plug and play functions from VPP-3.1*/

ViStatus _VI_FUNC hpe1445_init (ViRsrc InstrDesc, ViBoolean id_query,
                ViBoolean do_reset, ViPSession vi );
ViStatus _VI_FUNC hpe1445_close (ViSession vi);
ViStatus _VI_FUNC hpe1445_reset (ViSession vi);
ViStatus _VI_FUNC hpe1445_self_test (ViSession vi, ViPInt16 test_result,
                ViChar _VI_FAR test_message[]);
ViStatus _VI_FUNC hpe1445_error_query (ViSession vi, ViPInt32 error_number,
                ViChar _VI_FAR error_message[]);
ViStatus _VI_FUNC hpe1445_error_message (ViSession vi, ViStatus error_number,
                ViChar _VI_FAR message[]);
ViStatus _VI_FUNC hpe1445_revision_query (ViSession vi, 
		ViChar _VI_FAR driver_rev[], ViChar _VI_FAR instr_rev[]);

/* other standard functions */

ViStatus _VI_FUNC hpe1445_dcl(ViSession vi);
ViStatus _VI_FUNC hpe1445_errorQueryDetect(ViSession vi, ViBoolean errDetect);
ViStatus _VI_FUNC hpe1445_errorQueryDetect_Q(ViSession vi, ViPBoolean pErrDetect);
ViStatus _VI_FUNC hpe1445_timeOut (ViSession vi, ViInt32 timeOut);
ViStatus _VI_FUNC hpe1445_timeOut_Q (ViSession vi, ViPInt32 timeOut);

/* status functions */

ViStatus _VI_FUNC hpe1445_readStatusByte_Q(ViSession vi, ViPInt16 statusByte);
ViStatus _VI_FUNC hpe1445_operEvent_Q(ViSession vi, ViPInt32 sreg);
ViStatus _VI_FUNC hpe1445_operCond_Q(ViSession vi, ViPInt32 sreg );
ViStatus _VI_FUNC hpe1445_quesEvent_Q(ViSession vi, ViPInt32 sreg );
ViStatus _VI_FUNC hpe1445_quesCond_Q(ViSession vi, ViPInt32 sreg );

/* scpi escape functions */

ViStatus _VI_FUNC hpe1445_cmd( ViSession vi, ViString p1); 
ViStatus _VI_FUNC hpe1445_cmdString(ViSession vi, ViString p1,ViString p2,ViBoolean p3);

ViStatus _VI_FUNC hpe1445_cmdString_Q(ViSession vi, ViString p1, 
	ViInt32 p2,ViChar _VI_FAR p3[]);
ViStatus _VI_FUNC hpe1445_cmdInt16_Q(ViSession vi, ViString p1, ViPInt16 p2);
ViStatus _VI_FUNC hpe1445_cmdInt32_Q(ViSession vi, ViString p1, ViPInt32 p2);
ViStatus _VI_FUNC hpe1445_cmdReal64_Q(ViSession vi, ViString p1,ViPReal64 p2);
ViStatus _VI_FUNC hpe1445_cmdInt16Arr_Q(ViSession vi, ViString p1, 
	ViInt32 p2,ViInt16 _VI_FAR p3[],ViPInt32 p4);
ViStatus _VI_FUNC hpe1445_cmdInt( ViSession vi, ViString p1, ViInt32 p2,ViBoolean p3);
ViStatus _VI_FUNC hpe1445_cmdReal( ViSession vi, ViString p1, ViReal64 p2,ViBoolean p3);

/* the following use Real32 (float) types */
ViStatus _VI_FUNC hpe1445_opc_Q( ViSession vi,ViPBoolean p2);

ViStatus _VI_FUNC hpe1445_autoConnectToFirst(ViPSession vi);


/* END */

/******   Used by Function hpe1445_arbWave   *****/
#define  hpe1445_ARBRATEMAX  42.94e6
#define  hpe1445_ARBRATEMIN  0
#define  hpe1445_ARBAMPL_MAX  12.05
#define  hpe1445_ARBAMPL_MIN  -12.05
#define  hpe1445_ARBSEQNO_MAX  32768
#define  hpe1445_ARBSEQNO_MIN  0
#define  hpe1445_Z_50  50
#define  hpe1445_Z_75  75


/******   Used by Function hpe1445_couple1446   *****/
#define  hpe1445_46ATTENZERO  0
#define  hpe1445_46ATTEN20  20
#define  hpe1445_46UNUSED  -20
#define  hpe1445_46IMP0  0
#define  hpe1445_46IMP50  50
#define  hpe1445_46IMP75  75
/*  hpe1445_46UNUSED  */
#define  hpe1445_46OFFMAX  10.0
/*  hpe1445_46UNUSED  */


/******   Used by Function hpe1445_coupleCGFV   *****/
#define  hpe1445_CGFVPOINTSMAX  262144
#define  hpe1445_CGFVUNUSED  -1


/******   Used by Function hpe1445_coupleCGfreq   *****/
#define  hpe1445_CGFREQF2MAX  42.9497e6
#define  hpe1445_CGFREQUNUSED  -1
#define  hpe1445_CGFREQROSCMAX  42.94967296e6
/*  hpe1445_CGFREQUNUSED  */
#define  hpe1445_CGFREQSCOUNTMAX  2147483647
/*  hpe1445_CGFREQUNUSED  */


/******   Used by Function hpe1445_coupleCGvolt   *****/
#define  hpe1445_CGVOLT_UNUSED  -20
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */
/*  hpe1445_CGVOLT_UNUSED  */
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */
#define  hpe1445_CGVOLT_INF  9.9e37
#define  hpe1445_CGVOLT_AMPLMAX  12.05
/*  hpe1445_CGVOLT_UNUSED  */
/*  hpe1445_CGVOLT_AMPLMAX  */
/*  hpe1445_CGVOLT_UNUSED  */


/******   Used by Function hpe1445_coupleSourFreq1   *****/
#define  hpe1445_FREQ1MAX  42.94967296e6
#define  hpe1445_FREQ1_UNUSED  -1
/*  hpe1445_FREQ1MAX  */
/*  hpe1445_FREQ1_UNUSED  */
/*  hpe1445_FREQ1MAX  */
/*  hpe1445_FREQ1_UNUSED  */
#define  hpe1445_FREQ1_FSK2_MAX  42.94967296e6
#define  hpe1445_FREQ1_FSK2_MIN  0
/*  hpe1445_FREQ1MAX  */
/*  hpe1445_FREQ1_UNUSED  */
/*  hpe1445_FREQ1MAX  */
/*  hpe1445_FREQ1_UNUSED  */
/*  hpe1445_FREQ1MAX  */
/*  hpe1445_FREQ1_UNUSED  */
/*  hpe1445_FREQ1MAX  */
/*  hpe1445_FREQ1_UNUSED  */


/******   Used by Function hpe1445_coupleSourSweep   *****/
#define  hpe1445_SWEEPCOUNTCMAX  2147483647
#define  hpe1445_SWEEPUNUSED  -1
#define  hpe1445_SWEEPPOINTSMAX  1073741824
/*  hpe1445_SWEEPUNUSED  */
#define  hpe1445_REALMAX  1e39
/*  hpe1445_SWEEPUNUSED  */


/******   Used by Function hpe1445_coupleTrig   *****/
#define  hpe1445_TRIGPERIODMAX  4.19430375
#define  hpe1445_TRIGUNUSED  -1


/******   Used by Function hpe1445_createSeg   *****/
#define  hpe1445_SEGNO_MAX  262144
#define  hpe1445_SEGNO_MIN  8


/******   Used by Function hpe1445_fsk1   *****/
#define  hpe1445_FSKF1_MAX  42.94e6
#define  hpe1445_FSKF1_MIN  0
#define  hpe1445_FSKF2_MAX  42.94e6
#define  hpe1445_FSKF2_MIN  0
#define  hpe1445_FSKAMPL_MAX  12.05
#define  hpe1445_FSKAMPL_MIN  0
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */


/******   Used by Function hpe1445_sinWave   *****/
#define  hpe1445_SIN_FREQ_MAX  42.94e6
#define  hpe1445_SIN_FREQ_MIN  0
#define  hpe1445_SIN_AMPL_MAX  12.05
#define  hpe1445_SIN_AMPL_MIN  0
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */


/******   Used by Function hpe1445_squareWave   *****/
#define  hpe1445_SQU_FREQ_MAX  42.94e6
#define  hpe1445_SQU_FREQ_MIN  0
#define  hpe1445_SQU_AMPL_MAX  12.05
#define  hpe1445_SQU_AMPL_MIN  0
#define  hpe1445_SQU_OFFSETMAX  12.05
#define  hpe1445_SQU_OFFSETMIN  -12.05
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */


/******   Used by Function hpe1445_sweep   *****/
#define  hpe1445_SWEEPSTART_MAX  42.94e6
#define  hpe1445_SWEEPSTART_MIN  0
#define  hpe1445_SWEEPSTOP_MAX  42.94e6
#define  hpe1445_SWEEPSTOP_MIN  0
#define  hpe1445_SWEEPAMPL_MAX  12.05
#define  hpe1445_SWEEPAMPL_MIN  -12.05
#define  hpe1445_SWEEPPOINTS_MAX  262144
#define  hpe1445_SWEEPPOINTS_MIN  4
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */


/******   Used by Function hpe1445_triWave   *****/
#define  hpe1445_TRI_FREQ_MAX  42.94e6
#define  hpe1445_TRI_FREQ_MIN  0
#define  hpe1445_TRI_AMPL_MAX  12.05
#define  hpe1445_TRI_AMPL_MIN  0
#define  hpe1445_TRI_OFFSETMAX  12.05
#define  hpe1445_TRI_OFFSETMIN  -12.05
/*  hpe1445_Z_50  */
/*  hpe1445_Z_75  */
#define  hpe1445_TRI_POINTSMAX  262144
#define  hpe1445_TRI_POINTSMIN  4

ViStatus _VI_FUNC hpe1445_arbWave  (
  ViSession vi,
  ViReal64 samplerate,
  ViReal64 ampl,
  ViString sequence,
  ViInt32 seqlength,
  ViString seqorder,
  ViInt32 dwell[],
  ViInt32 impedance,
  ViString load);

ViStatus _VI_FUNC hpe1445_couple1446  (
  ViSession vi,
  ViInt32 attenuation,
  ViInt32 impedance,
  ViReal64 offset);

ViStatus _VI_FUNC hpe1445_coupleBegin  (
  ViSession vi);

ViStatus _VI_FUNC hpe1445_coupleCGFV  (
  ViSession vi,
  ViString dacsour,
  ViString shape,
  ViReal64 points);

ViStatus _VI_FUNC hpe1445_coupleCGfreq  (
  ViSession vi,
  ViReal64 sourfreq2,
  ViString freqlist2,
  ViString pmsource,
  ViString pmstate,
  ViReal64 roscfreq,
  ViString roscsour,
  ViInt32 armsweepcount,
  ViString armsweepsour);

ViStatus _VI_FUNC hpe1445_coupleCGvolt  (
  ViSession vi,
  ViInt32 impedance,
  ViReal64 load,
  ViString loadauto,
  ViString ramppol,
  ViReal64 ampl,
  ViReal64 offset);

ViStatus _VI_FUNC hpe1445_coupleEnd  (
  ViSession vi);

ViStatus _VI_FUNC hpe1445_coupleSourFreq1  (
  ViSession vi,
  ViReal64 center,
  ViReal64 fixed,
  ViReal64 fsk1,
  ViReal64 fsk2,
  ViString fskSour,
  ViString mode,
  ViReal64 range,
  ViReal64 span,
  ViReal64 start,
  ViReal64 stop);

ViStatus _VI_FUNC hpe1445_coupleSourSweep  (
  ViSession vi,
  ViInt32 count,
  ViString direction,
  ViInt32 points,
  ViString spacing,
  ViReal64 time);

ViStatus _VI_FUNC hpe1445_coupleTrig  (
  ViSession vi,
  ViString polarity,
  ViString gatesour,
  ViString gatestate,
  ViString startsour,
  ViString slope,
  ViString stopsour,
  ViString sweepsour,
  ViReal64 period);

ViStatus _VI_FUNC hpe1445_createSeg  (
  ViSession vi,
  ViString name,
  ViInt32 size,
  ViReal64 data[]);

ViStatus _VI_FUNC hpe1445_fsk1  (
  ViSession vi,
  ViReal64 freq1,
  ViReal64 freq2,
  ViReal64 ampl,
  ViString fsksource,
  ViInt32 impedance,
  ViString load);

ViStatus _VI_FUNC hpe1445_marker  (
  ViSession vi,
  ViString segment,
  ViInt16 markerlist[]);

ViStatus _VI_FUNC hpe1445_outpState  (
  ViSession vi,
  ViString state);

ViStatus _VI_FUNC hpe1445_sinWave  (
  ViSession vi,
  ViReal64 freq,
  ViReal64 ampl,
  ViInt32 impedance,
  ViString load);

ViStatus _VI_FUNC hpe1445_squareWave  (
  ViSession vi,
  ViReal64 freq,
  ViReal64 ampl,
  ViString polarity,
  ViReal64 offset,
  ViInt32 impedance,
  ViString load);

ViStatus _VI_FUNC hpe1445_sweep  (
  ViSession vi,
  ViString shape,
  ViReal64 startfreq,
  ViReal64 stopfreq,
  ViReal64 ampl,
  ViInt32 points,
  ViInt32 impedance,
  ViString load);

ViStatus _VI_FUNC hpe1445_triWave  (
  ViSession vi,
  ViReal64 freq,
  ViReal64 ampl,
  ViString polarity,
  ViReal64 offset,
  ViInt32 impedance,
  ViString load,
  ViInt32 points);




/* Used for "C" externs in C++ */
#if defined(__cplusplus) || defined(__cplusplus__)
}    /* end of "C" externs for C++ */
#endif 

#endif /* hpe1445_INCLUDE */

